@echo off

echo.
echo Installer for realtime raw data export disk scripts (VE-line)
echo E. Auerbach, CMRR, 2014-2016


if "%~1"=="" goto :argError
set workdir=%~1%

set errtotal=0

echo.
echo *** Installing scripts:


if not exist "%CustomerSeq%" mkdir "%CustomerSeq%"

set srcpath=%workdir%med.rc.boot
set dstpath=%MRIRHOME%\config\scripts\med.rc.boot

set tfil=eja_mount_rawdata_disk.sh & call :copyfile

set srcpath=%workdir%med.rc.setup
set dstpath=%MRIRHOME%\config\scripts\med.rc.setup

set tfil=eja_create_rawdata_fs.sh  & call :copyfile

if %errtotal% NEQ 0 (
    echo.
    echo ERROR! %errtotal% step^(s^) failed!
    goto :errcond
)


echo.
echo The raw data disk will now be formatted.
echo.
echo ALL EXISTING DATA ON THE RAW DATA DISK WILL BE DESTROYED!
echo.
echo If this is not a new disk, and you are absolutely sure that the disk has
echo already been formatted with the correct filesystem, this step may be
echo safely skipped.
echo.

:chooseFormat
set /P c=Are you sure you want to continue [(Y)es/(N)o/(S)kip]? 
if /I "%c%" EQU "Y" goto :formatDisk
if /I "%c%" EQU "N" goto :abort
if /I "%c%" EQU "S" goto :mountDisk
goto :chooseFormat


:formatDisk
echo.
echo Formatting raw data disk...
echo.
ssh root@mars /opt/med/config/scripts/med.rc.setup/eja_create_rawdata_fs.sh 
echo Waiting 10 seconds...
ping 1.1.1.1 -n 1 -w 10000 > nul


:mountDisk
echo.
echo Mounting raw data disk...
ssh root@mars "/opt/med/config/scripts/med.rc.boot/eja_mount_rawdata_disk.sh start"
echo.
echo Displaying mounted disks...
echo.
ssh root@mars "df -h"


:done
echo.
echo Done! You should see the raw data disk in the above list as '/rawdata'.
goto :end


:errcond
echo.
echo Unexpected error. Please restart the system before
echo running this installer again.
goto :end


:argerror
echo.
echo ERROR: Do not run this script directly! Please use the installer .exe only.
goto :abort


:abort
echo.
echo Installation aborted!
goto :end


:end
echo.
pause
exit /b


:copyfile
if exist "%srcpath%\%tfil%" (
    echo | set /p dummy=%tfil% ...  
    copy /y "%srcpath%\%tfil%" "%dstpath%" > nul
    if ERRORLEVEL 1 (
        echo failed!
        set /a errtotal+=1
    ) else (
        icacls "%dstpath%\%tfil%" /reset /q > nul
        if ERRORLEVEL 1 (
            echo failed!
            set /a errtotal+=1
        ) else (
            echo success!
        )
    )
)
goto:eof
