#!/bin/bash
#
# Author: E. Auerbach, CMRR, 2013-6
#
# /opt/med/config/scripts/med.rc.boot/eja_mount_rawdata_disk.sh
#
# This script mounts the raw data disk used for automatic raw data export
# (partitioned/formatted created by eja_create_rawdata_fs.sh).
# VE11 version (ext4).
#
# We are controlled by the SYSTEM_TYPE also known as Chassis Asset Tag
# which tells us which hardware platform we have.

case "$1" in
    start)
        # be sure we know the system type (it usually isn't exported on VE11)
        if [ -e /etc/system.type ]
        then
            . /etc/system.type
        fi

        # raw data disk should always be in bottom-most hot-swap slot (#8), or at least
        # after the last RAID disk.
        if [ "$SYSTEM_TYPE" = "" ]
        then
            echo "eja_mount_rawdata_disk.sh: SYSTEM_TYPE environment variable not set/exported! Aborting..."
            exit 1
        elif [ "$SYSTEM_TYPE" = "DD" ] || [ "$SYSTEM_TYPE" = "DE" ] || [ "$SYSTEM_TYPE" = "DH" ]
        then
            # 1 system + 2 RAID disks
            EJA_RAWDATA_DISK="/dev/sdd"
        elif [ "$SYSTEM_TYPE" = "DA" ] || [ "$SYSTEM_TYPE" = "DF" ]
        then
            # 1 system + 3 RAID disks
            EJA_RAWDATA_DISK="/dev/sde"
        elif [ "$SYSTEM_TYPE" = "CB" ] || [ "$SYSTEM_TYPE" = "CC" ] || [ "$SYSTEM_TYPE" = "DB" ]
        then
            # 1 system + 4 RAID disks
            EJA_RAWDATA_DISK="/dev/sdf"
        elif [ "$SYSTEM_TYPE" = "DG" ]
        then
            # 1 system + 5 RAID disks
            EJA_RAWDATA_DISK="/dev/sdg"
        elif [ "$SYSTEM_TYPE" = "DC" ]
        then
            # 1 system + 6 RAID disks
            EJA_RAWDATA_DISK="/dev/sdh"
        else
            echo "eja_mount_rawdata_disk.sh: Unknown or unsupported system type ${SYSTEM_TYPE}! Aborting..."
            exit 1
        fi
        
        if [ -n "$EJA_RAWDATA_DISK" ]
        then
            echo "eja_mount_rawdata_disk.sh: Mounting raw data disk ${EJA_RAWDATA_DISK}1 to /rawdata"
            if [ ! -d "/rawdata" ]
            then
                echo "eja_mount_rawdata_disk.sh: Creating /rawdata"
                mkdir /rawdata
            fi
            mount -t ext4 ${EJA_RAWDATA_DISK}1 /rawdata
        fi
        ;;
    stop)
        ;;
    *)
        echo "Usage: $0 {start|stop}"
        ;;
esac
