package org.nrg.xnat.protocol;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;



public class Protocol{
   	private String projectID;
   	private String versionDescription;
   	private List<VisitType> visitTypes;
   	private List<VisitName> visitNames;

 	public String getProjectID(){
		return this.projectID;
	}
	public void setProjectID(String projectID){
		this.projectID = projectID;
	}
 	public String getVersionDescription(){
		return this.versionDescription;
	}
	public void setVersionDescription(String versionDescription){
		this.versionDescription = versionDescription;
	}
 	public List<VisitType> getVisitTypes(){
		return this.visitTypes;
	}
	public void setVisitTypes(List<VisitType> visitTypes){
		this.visitTypes = visitTypes;
	}
 	public List<VisitName> getVisitNames(){
		return this.visitNames;
	}
	public void setVisitNames(List<VisitName> visitNames){
		this.visitNames = visitNames;
	}
	
	public List<ExpectedExperiment> getExpectedExperiments(String visitTypeName){
		
		List<VisitType> types = this.getVisitTypes();
		for(VisitType type :types){
			if( org.apache.commons.lang.StringUtils.equalsIgnoreCase( type.getName(), visitTypeName)){
				return type.getExpectedExperiments();
			}
		}
		return new ArrayList<ExpectedExperiment>();
	}
	
	public boolean isExpectedExperiment(String visitTypeName, String experimentType){
		List<ExpectedExperiment> exps = this.getExpectedExperiments(visitTypeName);
		for(ExpectedExperiment ex : exps){
			if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(ex.getType(), experimentType)){
				return true;
			}
		}
		return false;
	}
	//returns null if the experimenttype passed in is not expected for this visitType. otherwise, it returns the expected experiment so that you can get moar datas abouts it.
	public ExpectedExperiment getExpectedExperiment(String visitTypeName, String experimentType){
		List<ExpectedExperiment> exps = this.getExpectedExperiments(visitTypeName);
		for(ExpectedExperiment ex : exps){
			if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(ex.getType(), experimentType)){
				return ex;
			}
		}
		return null;
	}
	//method checks the protocol for any errors. Specifically, having a visitName with a validType that isn't specified in visitTypes.
	//we can always add more as the need arises. For ex, should we check types to make sure they're valid? we could, no problem.
	//returns null if valid. returns a string of error messages if invalid.
	public String validate(){

		StringBuffer errors = new StringBuffer();
		Set<String> allValidTypes = new HashSet<String>(); //lets us add everything and not worry about duplicates.
		for(VisitName vn : visitNames){
			allValidTypes.addAll(vn.getValidTypes());
		}
		
		Set<String> allVisitTypes = new HashSet<String>();
		for(VisitType visitType:visitTypes){
			allVisitTypes.add(visitType.getName());
		}
		for(String vt:allValidTypes){
			if(!allVisitTypes.contains(vt)){
				errors.append(vt + " was specified in a VisitName as a valid type, but it was not specified as a VisitType.\n");
			}
		}
		//TODO: better error handling or logging goes here.
		if(errors.length()< 1) {
			return null;
		} else {
			return errors.toString();
		}
	}
	public String toHTML(){
		StringBuffer sb = new StringBuffer();
		
		sb.append("<ul><li>").append(projectID).append("</li>");
		sb.append("<li>").append(versionDescription).append("</li>");
		sb.append("<li>VisitNames<ul>");
		for(VisitName vn:visitNames){
			sb.append("<li>").append(vn.getName()).append("</li>");
			sb.append("<li>").append(vn.getDescription()).append("</li>");
			sb.append("<li>").append(vn.getDelta()).append("</li>");
			sb.append("<li>ValidTypes<ul>");
			for(String vt:vn.getValidTypes()){
				sb.append("<li>").append(vt).append("</li>");
			}
			sb.append("</ul></li>");
		}
		sb.append("</ul></li>");
		
		sb.append("<li>VisitTypes<ul>");
		for(VisitType vt:visitTypes){
			sb.append("<li>").append(vt.getName()).append("</li>");
			sb.append("<li>").append(vt.getDescription()).append("</li>");
			sb.append("<li>Expected Experiments<ul>");
			for(ExpectedExperiment ee:vt.getExpectedExperiments()){
				sb.append("<li>").append(ee.getType()).append("</li>");
				sb.append("<li>").append(ee.getProtocol()).append("</li>");
				sb.append("<li>").append(ee.getRequired()).append("</li>");
				sb.append("<li>").append(ee.getSortOrder()).append("</li>");
				sb.append("<li>").append(ee.getUserEntered()).append("</li>");
			}
			sb.append("</ul></li>");
		}
		sb.append("</ul></li>");
		
		sb.append("</ul>");
		return sb.toString();
	}
}

