package org.nrg.xnat.protocol;

import java.util.List;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.nrg.xdat.om.base.BaseXnatPvisitdata;

public class VisitName implements Comparable<VisitName>{
   	private Number delta;
   	private String description;
   	private String name;
   	private boolean required;
   	
   	private List<String> validTypes; //these should probably be object refs to the objects in the visitTypes array, but json makes that hard.

 	public Number getDelta(){
		return this.delta;
	}
	public void setDelta(Number delta){
		this.delta = delta;
	}
 	public String getDescription(){
		return this.description;
	}
	public void setDescription(String description){
		this.description = description;
	}
 	public String getName(){
		return this.name;
	}
	public void setName(String name){
		this.name = name;
	}
 	public boolean getRequired(){
		return this.required;
	}
	public void setRequired(boolean required){
		this.required = required;
	}
 	public List<String> getValidTypes(){
		return this.validTypes;
	}
	public void setValidTypes(List<String> validTypes){
		this.validTypes = validTypes;
	}
	
	
	public int hashCode() {
        return new HashCodeBuilder(13, 37). // two randomly chosen prime numbers
            // if deriving: appendSuper(super.hashCode()).
        	append(this.getName()).
        	append(this.getDelta()).
            toHashCode();
    }

	public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj == this)
            return true;
        if (obj.getClass() != getClass())
            return false;

        VisitName rhs = (VisitName) obj;
        return new EqualsBuilder().
            // if deriving: appendSuper(super.equals(obj)).
        	append(this.getName(), rhs.getName()).
        	append(this.getDelta(), rhs.getDelta()).
            
            isEquals();
    }

	public int compareTo(VisitName rhs) {
		return new CompareToBuilder().
				append(this.getDelta(), rhs.getDelta()).
				append(this.getName(), rhs.getName()).
	            toComparison();
	}
}
