package org.nrg.xnat.restlet.extensions;

import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.xdat.model.XnatExperimentdataShareI;
import org.nrg.xdat.om.XnatExperimentdata;
import org.nrg.xdat.om.XnatExperimentdataShare;
import org.nrg.xdat.om.XnatProjectdata;
import org.nrg.xdat.om.XnatPvisitdata;
import org.nrg.xdat.om.XnatSubjectdata;
import org.nrg.xft.ItemWrapper;
import org.nrg.xft.event.EventMetaI;
import org.nrg.xft.security.UserI;
import org.nrg.xft.utils.SaveItemHelper;
import org.nrg.xnat.restlet.XnatRestlet;
import org.nrg.xnat.restlet.resources.SecureResource;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Variant;

@XnatRestlet({"/projects/{PROJECT_ID}/subjects/{SUBJECT_ID}/experiments/{EXPERIMENT_ID}/visit/{VISIT_ID}"})
public class ProjExpVisit  extends SecureResource {
	private static final Log _log = LogFactory.getLog(ProjExpVisit.class);
	XnatProjectdata project=null;
	XnatSubjectdata subject=null;
	XnatExperimentdata experiment=null;
	XnatPvisitdata visit = null;
	
	public ProjExpVisit(Context context, Request request, Response response) {
		
		super(context, request, response);
		
		//we need to grab the project, subject, experiment and visit.
		String projectId = (String) getParameter(request,"PROJECT_ID");
		String subjectId = (String) getParameter(request,"SUBJECT_ID");
		String experimentId = (String) getParameter(request,"EXPERIMENT_ID");
		String visitId = (String) getParameter(request,"VISIT_ID");

		if(projectId!=null){
			project = XnatProjectdata.getProjectByIDorAlias(projectId, user, false);
		}
		if (project == null) {
			response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to identify project " + projectId);
			return;
		}
		subjectId = (String) getParameter(request,"SUBJECT_ID");
		if(subjectId!=null){
			subject = XnatSubjectdata.GetSubjectByProjectIdentifier(project.getId(), subjectId, user, false);
		}
		if(subject==null){
			subject = XnatSubjectdata.getXnatSubjectdatasById(subjectId, user, false);
			if (subject != null && (project != null && !subject.hasProject(project.getId()))) {
				subject = null;
			}
		}
		if(subject==null){
			response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to identify subject " + subject);
		}
		
		experimentId = (String) getParameter(request,"EXPERIMENT_ID");
		if(experimentId!=null){
			experiment = XnatExperimentdata.getXnatExperimentdatasById(experimentId, user, completeDocument);
			if (experiment != null && (project != null && !experiment.hasProject(project.getId()))) {
				response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Experiment " + experimentId + " not associated with project " + projectId);
				return;
			}
		}
		if (experiment == null) {
			response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to identify experiment " + experimentId);
			return;
		}

		visitId = (String) getParameter(request,"VISIT_ID");
		if(visitId!=null){
			visit = XnatPvisitdata.getXnatPvisitdatasById(visitId, user, completeDocument);
			//visits aren't really associated with projects in anyway so we don't have to test that here.
		}
		if (visit == null) {
			response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to identify visit " + visitId);
			return;
		}
		
		this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
		this.getVariants().add(new Variant(MediaType.TEXT_HTML));
		this.getVariants().add(new Variant(MediaType.TEXT_XML));
	}
	@Override
	public boolean allowDelete() {
		return true;
	}
	@Override
	public void handleDelete(){
		//this removes any association between the visit and experiment.
		boolean goterdone = false;
		String unsharedVisit = experiment.getVisit();
		String visitId = visit.getId();
		if(visitId.equalsIgnoreCase(unsharedVisit)){
			experiment.setVisit("NULL");
			try {
				experiment.save(user, true, false, null);
				goterdone = true;
			} catch (Exception e) {
				this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to remove visit " + visitId + " from experiment " + experiment.getId() + " cause: " + e.getMessage());
				return;
			}
		} else {
			for(XnatExperimentdataShareI pp : experiment.getSharing_share()){
				if(pp.getProject().equals(this.project.getId()) && visitId.equalsIgnoreCase(pp.getVisit())){
					EventMetaI c = null;
					try {
						pp.setVisit("NULL");		
						SaveItemHelper.authorizedSave(((XnatExperimentdataShare)pp).getItem(), user, true, false, c);
						goterdone = true;
					} catch (Exception e) {
						this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to remove visit " + visit.getId() + " from experiment " + experiment.getId() + " shared project edition, cause: " + e.getMessage());
						return;
					}
					break;
				}
			}
		}
		if(goterdone){
			this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Not an error FIXX THIS everything is good.... ");
			return;
		} else {
			this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Something didn't work... ");
			return;
		}
	}
	@Override
	public boolean allowPut() {
		return true;
	}
	@Override
	public void handlePut(){
		//this will associate an experiment with the visit if possible.
		String projectId = project.getId();
		String visitId = visit.getId();
		boolean goterdone = false;
		if(projectId.equalsIgnoreCase(experiment.getProject())){
			experiment.setVisit(visitId);
			try {
				experiment.save(user, true, false, null);
				goterdone = true;
			} catch (Exception e) {
				this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to add visit " + visitId + " to experiment " + experiment.getId() + " cause: " + e.getMessage());
				return;
			}
		}else {
			for(XnatExperimentdataShareI pp : experiment.getSharing_share()){
				if(pp.getProject().equals(this.project.getId()) && visitId.equalsIgnoreCase(pp.getVisit())){
					EventMetaI c = null;
					try {
						pp.setVisit(visitId);		
						SaveItemHelper.authorizedSave(((XnatExperimentdataShare)pp).getItem(), user, true, false, c);
						goterdone = true;
					} catch (Exception e) {
						this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Unable to add visit " + visit.getId() + " to experiment " + experiment.getId() + " shared project edition, cause: " + e.getMessage());
						return;
					}
					break;
				}
			}
		}
		if(goterdone){
			this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Not an error FIXX THIS everything is good.... ");
			return;
		} else {
			this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Something didn't work... ");
			return;
		}

	}
    @Override
    public void handleGet() {
    	//not sure what this'll do...
    }
}
