package org.nrg.xnat.turbine.modules.actions;

import org.apache.log4j.Logger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.nrg.xdat.om.XnatPvisitdata;
import org.nrg.xdat.om.XnatSubjectdata;
import org.nrg.xdat.turbine.modules.actions.ModifyItem;
import org.nrg.xdat.turbine.utils.TurbineUtils;
import org.nrg.xft.XFTItem;

public class ModifyPvisit extends ModifyItem {
	static Logger logger = Logger.getLogger(ModifyPvisit.class);

	//generate the ID and label before you create a new visit.
    public void preProcess(XFTItem item,RunData data, Context context){
    	try {
    		if(item.getCurrentDBVersion() == null){
    			item.setProperty("ID", XnatPvisitdata.CreateNewID());

    			//TODO: probably want to move label creation somewhere more universal. maybe in XnatPvisitdata? maybe. I'd like to see it in a more, project specific and configurable location
    			item.setProperty("label", "v_"+(String)item.getProperty("subject_id")+"_"+(String)item.getProperty("visit_name")+"_"+(String)item.getProperty("visit_type"));
    		}
    	} catch (Exception e) {
            logger.error("",e);
            data.setMessage("Error: Item preProcess failed.  See log for details.");
            handleException(data,item,null);
        }
    }
    
    //redirect to the subject page. Not sure if this is a good way to do that or not...
    public void postProcessing(XFTItem item,RunData data, Context context) throws Exception{

    	//load the subject
        XnatSubjectdata sub = new XnatSubjectdata();
        sub.setId((String)item.getProperty("subject_id"));
        XFTItem current = sub.getItem().getCurrentDBVersion();
        
        //prepare turbine and redirect
    	data = TurbineUtils.setDataItem(data,current);
    	data = TurbineUtils.SetSearchProperties(data,current);

        this.redirectToReportScreen("XDATScreen_report_xnat_subjectData.vm", current, data);

    }
	
}
