package org.nrg.xnat.protocol;

import java.util.List;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.nrg.xdat.om.XnatExperimentdata;

public class ExperimentAssessorContainer {
	private XnatExperimentdata experiment;
	private List<XnatExperimentdata> assessors;
	
	public XnatExperimentdata getExperiment() {
		return experiment;
	}
	public void setExperiment(XnatExperimentdata experiment) {
		this.experiment = experiment;
	}
	public List<XnatExperimentdata> getAssessors() {
		return assessors;
	}
	public void setAssessors(List<XnatExperimentdata> assessors) {
		this.assessors = assessors;
	}
	public int hashCode() {
        return new HashCodeBuilder(19, 31). // two randomly chosen prime numbers
            // if deriving: appendSuper(super.hashCode()).
        	append(this.getExperiment()).
            toHashCode();
    }

	public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj == this)
            return true;
        if (obj.getClass() != getClass())
            return false;

        ExperimentAssessorContainer rhs = (ExperimentAssessorContainer) obj;
        return new EqualsBuilder().
            // if deriving: appendSuper(super.equals(obj)).
        	append(this.getExperiment(), rhs.getExperiment()).
            isEquals();
    }

}
