package org.nrg.xnat.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;

import org.codehaus.jackson.map.ObjectMapper;
import org.nrg.config.entities.Configuration;
import org.nrg.config.services.ConfigService;
import org.nrg.xdat.XDAT;
import org.nrg.xdat.om.XnatExperimentdata;
import org.nrg.xdat.om.XnatExperimentdataShare;
import org.nrg.xdat.om.XnatImageassessordata;
import org.nrg.xdat.om.XnatProjectdata;
import org.nrg.xdat.om.XnatPvisitdata;
import org.nrg.xdat.om.XnatSubjectdata;
import org.nrg.xdat.security.XDATUser;
import org.nrg.xft.XFTItem;
import org.nrg.xft.XFTTable;
import org.nrg.xft.exception.ElementNotFoundException;
import org.nrg.xft.exception.XFTInitException;
import org.nrg.xft.search.ItemSearch;
import org.nrg.xft.search.TableSearch;
import org.nrg.xft.utils.StringUtils;

public  class PulledOutOfBaseXnatSubject {
    
	//protected Map<XnatPvisitdata, List<ExperimentAssessorContainer>> visits = null;

    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(PulledOutOfBaseXnatSubject.class);
    
    public PulledOutOfBaseXnatSubject(){
    	
    }
 
	public static Protocol getProtocol(String projectID, XDATUser user) throws Exception{
		Protocol theProtocol = null;
		
		//grab the protocol config file
		ConfigService configService = XDAT.getConfigService();
		Callable<Long> getProjectId = null;
		if(projectID != null){
			final XnatProjectdata p = XnatProjectdata.getXnatProjectdatasById(projectID, user, false);
			if(!user.canRead(("xnat:subjectData/project").intern(), p.getId())){
				
				logger.error("User cannot access data for this project");
		    	return null;
			}
			getProjectId = new Callable<Long>() { public Long call() { return new Long((Integer)p.getItem().getProps().get("projectdata_info"));}};
		} else {
			getProjectId = new Callable<Long>() { public Long call() { return null; }};
		}
		Configuration config = configService.getConfig("protocols", "protocol", getProjectId);
		if(config == null){
			logger.error("no protocol found for this project: " + projectID);
	    	return null;
		}
		if(Configuration.DISABLED_STRING.equalsIgnoreCase(config.getStatus())){
			logger.info("protocol was disabled for " + projectID);
			return null;
		}
		String protocolJson = config.getContents();
		if(protocolJson == null){
			logger.error("no protocol found for this project: " + projectID);
	    	return null;			
		}
		ObjectMapper mapper = new ObjectMapper(); 
		theProtocol = mapper.readValue(protocolJson, Protocol.class);
		String validateString = theProtocol.validate();
		if(validateString != null){
			logger.error("the protocol is invalid: " + validateString);
			return null;
		}
		return theProtocol;
	}

	//this version returns a map of Objects. 
	//returns null if there's an error or if there is no protocol... would be nice to be able to 
	public static Map<String,Map> generateVisitObject(String projectID, XDATUser user, XnatSubjectdata subject) throws Exception{

		Map<XnatPvisitdata, List<ExperimentAssessorContainer>> visits = PulledOutOfBaseXnatSubject.getVisits(projectID, subject);
		 
		Map<String,Map> sb = new HashMap<String,Map>();
		try {		
		//visitname is sortable so use a treemap.
		sb.put("ALLVISITS", new TreeMap<VisitName,String>()); //just sort of a hacky way to get all the visitNames for this protocol to the UI.
		sb.put("VALID", new TreeMap<VisitName,HashMap>());
		sb.put("INVALID", new TreeMap<VisitName,HashMap>());
		sb.put("EXTRA", new HashMap<XnatPvisitdata,Set<ExperimentAssessorContainer>>());
		sb.put("MISSING", new TreeMap<VisitName,List<VisitType>>());
		
		ArrayList<XnatPvisitdata> pVisitDatasFound = new ArrayList<XnatPvisitdata>();  //this is used to find any "extra" visits (see the last step in this method)
		
		//sort by natural ordering of visitNames (visitName is comparable)
		Protocol theProtocol = PulledOutOfBaseXnatSubject.getProtocol(projectID, user);
		if(theProtocol == null){
			return null;
		}
		List<VisitName> sorted = theProtocol.getVisitNames();
		Collections.sort(sorted);
	
		
		//loop over all the visitNames (like baseline, v0, v1, etc) as defined in the protocol.
		for(VisitName visitName : sorted) {
			
			sb.get("ALLVISITS").put(visitName, "visitNamePlaceholder");  //I want to store the visitname so I can grab it in the UI. problem is, this is a map. SO, I put a dummy placeholder
			
			//go through the subject's visit's and as you find pvisitdatas who's visit column equals the current visitName.name. store that pvisitdata in pVisitDatasFound.			
			XnatPvisitdata foundVisitData = null;
			for(XnatPvisitdata visitData: visits.keySet()){
				if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(visitData.getVisitName(), visitName.getName())){
					foundVisitData = visitData;
					pVisitDatasFound.add(foundVisitData);
					break;
				}
			}
			
			if(foundVisitData != null){
				//the subject has at least one visit who's name matches one in the protocol
			    //see if that visit has a valid visitType for this visitName
				String isValidType = null;
				for(String type : visitName.getValidTypes()){
					if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(type, foundVisitData.getVisitType())){
						isValidType = type;
						break;
					}
				}
				if(isValidType != null){
					//we found a pvisitdata that is a recognized type and name (like V0, inHospital)
					
					sb.get("VALID").put(visitName,new HashMap<String,HashMap>());
					
					//pull the validType object out of the protocol so we can use it as metadata.
					VisitType visitType = null;
					for(VisitType vt: theProtocol.getVisitTypes()){
						if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(foundVisitData.getVisitType(), vt.getName())){
							visitType = vt;
							break;
						}
					}
					if(visitType == null){
						throw new Exception("The protocol's visit has a visit type (" + foundVisitData.getVisitType() + ") set that isn't specified in the protocol as a valid visitType. Unable to process! Fix your protocol.");
					}
					HashMap<String,Object> b = (HashMap)sb.get("VALID").get(visitName);
					b.put("VISITTYPE", visitType);
					b.put("VISITDATA", foundVisitData);
					b.put("EXPERIMENTS", new TreeMap<ExpectedExperiment, ExperimentAssessorContainer>());   // a map of experiments that are valid per the visitType's list of expected experiments. a map is used to map the expected experiment with the one we found that matched.
					
					b.put("MISSING", new ArrayList<ExpectedExperiment>());  //expected experiment is comparable so use a treeset
					b.put("EXTRA", new ArrayList<ExperimentAssessorContainer>());

					ArrayList<XnatExperimentdata> experimentsFound = new ArrayList<XnatExperimentdata>(); //used to find any extra experiments meaning an experiment that isn't in the visitType's valid experiment list
					
					//sort the expected experiments (from the protocol) using natural ordering.
					List<ExpectedExperiment> sortedExpts = visitType.getExpectedExperiments();
					Collections.sort(sortedExpts);
					
					for(ExpectedExperiment expectedExperiment : sortedExpts){
						//for each experiment we expect the subject to have per the visitname/type combo specified in the protocol.
						
						//search the subject's current visit's experiments for an experiment that corresponds to an expected visit.
						//TODO: this only finds a random one and stops. If there are multiple, then it will randomly pick one.
						ExperimentAssessorContainer correspondingExperiment = null;
						for(ExperimentAssessorContainer container : visits.get(foundVisitData)){
							XnatExperimentdata subjectsExperiment = container.getExperiment();
							if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(subjectsExperiment.getXSIType(), expectedExperiment.getType())){
								//TODO: this only matches by xsitype. It ignores protocol or really any other data that should probably not be ignored...
								correspondingExperiment = container;
								break;
							}
						}
//TODO: THIS MAY BE BROKEN HERE. IT SEEMS TO ONLY FIND ONE VALID EXPERIMENT. 
						if(correspondingExperiment != null){
							//you found an expected experiment so store it
							experimentsFound.add(correspondingExperiment.getExperiment());
							((Map)b.get("EXPERIMENTS")).put(expectedExperiment,correspondingExperiment);
							
						} else {
							//an expected experiment is missing. if it is required, make it bolder
							((List)b.get("MISSING")).add(expectedExperiment);
						}
					}

					//now let's find any extra experiments. These are experiments the subject has in the current visit that don't correspond to any in the protocol's expected experiment list for this visitType.

					for(ExperimentAssessorContainer container: visits.get(foundVisitData)){
						XnatExperimentdata subjectsExperiment = container.getExperiment();
						if(!experimentsFound.contains(subjectsExperiment)){
							((List)b.get("EXTRA")).add(container);
						}
					}

			    } else {
			    	//this represents a pVisitData that has a type that is not specified in the protocol as a valid type. Since it is not specified, we can't really do anything with it except display it and all it's experiments
			    	sb.get("INVALID").put(visitName,new HashMap<String,HashMap>());
			    	HashMap<String,Object> b = (HashMap)sb.get("INVALID").get(visitName);
			    	b.put("VISITDATA", foundVisitData);
					b.put("EXPERIMENTS", new HashSet<ExperimentAssessorContainer>()); 
					
			    	for(ExperimentAssessorContainer container : visits.get(foundVisitData)){
			    		XnatExperimentdata invalidExperiment = container.getExperiment();
			    		((Set)b.get("EXPERIMENTS")).add(container);
			    	}	
			    	
//			    	sb.get("INVALID").put(foundVisitData,new HashSet<XnatExperimentdata>());
//			    	
//			    	for(XnatExperimentdata invalidExperiment : visits.get(foundVisitData)){
//			    		((Set)sb.get("INVALID").get(foundVisitData)).add(invalidExperiment);
//			    	}		      
				}
			} else {
				//we didn't find a pvisitdata that corresponds to this visitName. So, write out a link to create it.
				Set<VisitType> validTypes = new HashSet<VisitType>();
				List<VisitType> protocolVisitTypes = theProtocol.getVisitTypes();
				for(String typeName : visitName.getValidTypes()){
					for(VisitType type:protocolVisitTypes){
						if(org.apache.commons.lang.StringUtils.equalsIgnoreCase(type.getName(),typeName)){
							validTypes.add(type);
							break;
						}
					}
				}
				sb.get("MISSING").put(visitName, validTypes);
			}
		}
		
		
		// now we want to go through the visits to find any that aren't even specified in the protocol. For example "someBogusVisitName" would get written out here.
		// we can't do much more than just write out what we found because there is no information in the protocol for this visit.
        //TLDR;a pvisitdata exists in xnat but no visitName in the protocol matches it
		for(XnatPvisitdata visitData: visits.keySet()){
			
			if(!pVisitDatasFound.contains(visitData)){

				sb.get("EXTRA").put(visitData,new HashSet<XnatExperimentdata>());

				for(ExperimentAssessorContainer container:visits.get(visitData)){
					XnatExperimentdata expt = container.getExperiment();
					//this invalid visit has experiments so we'll have to write those out here.
					((Set)sb.get("EXTRA").get(visitData)).add(container);
				}
			}
		}		

} catch (Exception e){
	System.out.println(e);
	logger.error("Unable to generate the protocol's visit object",e);

}		return sb;

	}

	public static Map<XnatPvisitdata, List<ExperimentAssessorContainer>> getVisits(String projectID, XnatSubjectdata subject)
	{
	
			TreeMap<XnatPvisitdata, List<ExperimentAssessorContainer>> visits = new TreeMap<XnatPvisitdata, List<ExperimentAssessorContainer>>();
			try{
				XFTTable table = TableSearch.Execute("SELECT ex.id,ex.date,me.element_name AS type,ex.project,me.element_name,ex.note AS note,projects, " +
				"ex.label,vd.id as visit_id, vd.visit_type as visit_type, vd.visit_name as interval, ex.protocol as protocol " + 
				"FROM xnat_subjectAssessorData assessor " + 
				"LEFT JOIN xnat_experimentData ex ON assessor.ID=ex.ID " + 
				"LEFT JOIN xnat_experimentdata v on v.id = ex.visit " + 
				"INNER JOIN xnat_pvisitdata vd on vd.id = v.id " + 
				"LEFT JOIN xdat_meta_element me ON ex.extension=me.xdat_meta_element_id " + 
				"LEFT JOIN ( " + 
				"  SELECT xs_a_concat(project || ':' || label || ',') AS PROJECTS, " + 
				"  sharing_share_xnat_experimentda_id FROM xnat_experimentData_share " + 
				"  GROUP BY sharing_share_xnat_experimentda_id) PROJECT_SEARCH ON ex.id=PROJECT_SEARCH.sharing_share_xnat_experimentda_id " + 
				"WHERE (ex.visit != '' or ex.visit is not null) and assessor.subject_id='" + subject.getId() +"'  and ex.project = '" + projectID + "' ORDER BY ex.date ASC;",subject.getDBName(),null);
				table.resetRowCursor();
                while (table.hasMoreRows())
                {
                	final Hashtable row = table.nextRowHash();
                    final String element = (String)row.get("element_name");
                    try {
                    	final XFTItem child = XFTItem.NewItem(element,subject.getUser());

                        final Object id = row.get("id");
                        final Object visit_id = row.get("visit_id");

                        final String projects = (String)row.get("projects");
                        if (projects!=null)
                        {
                            for(final String projectName:StringUtils.CommaDelimitedStringToArrayList(projects, true))
                            {
                               if(projectName.indexOf(":")>-1){
                            	   XnatExperimentdataShare es = new XnatExperimentdataShare(subject.getUser());
                            	   es.setProject(projectName.substring(0,projectName.indexOf(":")));
                            	   if(!projectName.endsWith(":")){
                            		   es.setLabel(projectName.substring(projectName.indexOf(":")+1));
                            	   }
                            	   child.setChild("xnat:experimentData/sharing/share",es.getItem(),false);
                               }else{
                                   child.setProperty("sharing.share.project", projectName);
                               }
                            }
                        }
                        if (child.instanceOf("xnat:imageSessionData"))
                        {
                        	//if you are looking at an imageSessionData, check for any imageAssessors. ImageAssessors are never associated with a visit. they just sort of
                        	//come along with their image session's visit.
                        	XnatPvisitdata bill = new XnatPvisitdata(ItemSearch.GetItem("xnat:pvisitData/id", visit_id, null, true));
                        	if(visits.get(bill) == null){
                        		visits.put(bill, new ArrayList<ExperimentAssessorContainer>());
                        	}
                        	ExperimentAssessorContainer container = new ExperimentAssessorContainer();
                        	container.setExperiment(new XnatExperimentdata(ItemSearch.GetItem("xnat:imageSessionData/id", id, null, true)));
                        	visits.get(bill).add(container);
                        	
                            try {   	
                                XFTTable table2 = TableSearch.Execute("SELECT ex.id,ex.date,me.element_name AS type,ex.project,me.element_name,ex.note AS note, " +
                                		"projects,ex.label,assessor.imagesession_id , ex.protocol " + 
                                		"FROM xnat_imageAssessorData assessor " + 
                                		"LEFT JOIN xnat_experimentData ex ON assessor.ID=ex.ID " + 
                                		"LEFT JOIN xnat_experimentdata v on v.id = ex.visit " +
                                		"LEFT JOIN xdat_meta_element me ON ex.extension=me.xdat_meta_element_id " + 
                                		"LEFT JOIN ( " +
                                		"  SELECT xs_a_concat(project || ':' || label || ',') AS PROJECTS, sharing_share_xnat_experimentda_id " + 
                                		"  FROM xnat_experimentData_share GROUP BY sharing_share_xnat_experimentda_id) " + 
                                		"  PROJECT_SEARCH ON ex.id=PROJECT_SEARCH.sharing_share_xnat_experimentda_id " + 
                                		"WHERE  assessor.imagesession_id='" + id +"' and ex.project = '" + projectID + "' ORDER BY ex.date ASC "
                                			,subject.getDBName(),null);
                                table2.resetRowCursor();
                                while (table2.hasMoreRows())
                                {
                                	final Hashtable row2 = table2.nextRowHash();
                                	final String element2 = (String)row2.get("element_name");
                                    try {
                                    	final XFTItem child2 = XFTItem.NewItem(element2,subject.getUser());
                                        final Object id2 = row2.get("id");

                                        final String projects2 = (String)row2.get("projects");
                                        if (projects2!=null)
                                        {
                                        	for(final String projectName:StringUtils.CommaDelimitedStringToArrayList(projects2, true))
                                            {
                                               if(projectName.indexOf(":")>-1){
                                            	   final XnatExperimentdataShare es = new XnatExperimentdataShare(subject.getUser());
                                            	   es.setProject(projectName.substring(0,projectName.indexOf(":")));
                                            	   if(!projectName.endsWith(":")){
                                            		   es.setLabel(projectName.substring(projectName.indexOf(":")+1));
                                            	   }
                                            	   child2.setChild("xnat:experimentData/sharing/share",es.getItem(),false);
                                               }else{
                                                   child2.setProperty("sharing.share.project", projectName);
                                               }
                                            }
                                        }
                                        

                                        XnatPvisitdata bill2 = new XnatPvisitdata(ItemSearch.GetItem("xnat:pvisitData/id", visit_id, null, true));
                                    	if(visits.get(bill2) == null){
                                    		visits.put(bill2, new ArrayList<ExperimentAssessorContainer>());
                                    	}
                                    	
                                    	if(container.getAssessors() == null){ 
                                    		container.setAssessors(new ArrayList<XnatExperimentdata>()); 
                                    	}
                                    	container.getAssessors().add(new XnatImageassessordata(ItemSearch.GetItem(child2.getXSIType()+"/id", id2, null, true)));
                                    	//visits.get(bill2).add(new XnatImageassessordata(ItemSearch.GetItem(child2.getXSIType()+"/id", id2, null, true)));
                                    	
                                    } catch (XFTInitException e) {
                                        logger.error("",e);
                                    } catch (ElementNotFoundException e) {
                                        logger.error("",e);
                                    }
                                }
                            } catch (Exception e) {
                                logger.error("",e);
                            }
                        }else{
                        	//this code negates the need for the large select clause in the queries above. I just need the id's...
                        	XnatPvisitdata bill = new XnatPvisitdata(ItemSearch.GetItem("xnat:pvisitData/id", visit_id, null, true));
                        	if(visits.get(bill) == null){
                        		visits.put(bill, new ArrayList<ExperimentAssessorContainer>());
                        	}
                        	ExperimentAssessorContainer container = new ExperimentAssessorContainer();
                        	container.setExperiment(new XnatExperimentdata(ItemSearch.GetItem("xnat:imageSessionData/id", id, null, true)));
                        	visits.get(bill).add(container);
                        	//visits.get(bill).add(new XnatExperimentdata(ItemSearch.GetItem(child.getXSIType()+"/id", id, null, true)));
                        	
                        			
                        }
                    } catch (XFTInitException e) {
                        logger.error("",e);
                    } catch (ElementNotFoundException e) {
                        logger.error("",e);
                    }
                }
                
                //now we have to query for any visits that don't have experiments associated with them yet. if any exist, add them to the map.
            	StringBuffer q = new StringBuffer("SELECT v.id as visit_id  FROM xnat_experimentdata v " +
    	                "INNER JOIN xnat_pvisitdata vd on vd.id = v.id  " + 
    	                "LEFT JOIN xdat_meta_element me ON v.extension=me.xdat_meta_element_id  " + 
    	                "LEFT JOIN (   " +
    	                "  SELECT xs_a_concat(project || ':' || label || ',') AS PROJECTS,  " +
    	                "  sharing_share_xnat_experimentda_id FROM xnat_experimentData_share  " +
    	                "  GROUP BY sharing_share_xnat_experimentda_id) PROJECT_SEARCH ON v.id=PROJECT_SEARCH.sharing_share_xnat_experimentda_id  " +
    	                "WHERE subject_id='" + subject.getId() +"' and v.project = '" + projectID + "'"); 
            	

                if(visits.keySet().size()>0) {
                	q.append(" and not vd.id in ('");
	                for (XnatPvisitdata visit:visits.keySet()){
	                	q.append(visit.getId()).append("', '");
	                }
	                q.append("99999199999999') "); //awful hack to make comma/apostrophe logic simple and clear.
                }
                q.append(" ORDER BY v.date ASC; ");
                XFTTable table3 = TableSearch.Execute(q.toString() ,subject.getDBName(),null);
                table3.resetRowCursor();
                while (table3.hasMoreRows())
                {
                	final Hashtable row = table3.nextRowHash();

                    try {
   

                        final Object visit_id = row.get("visit_id");
                        
                        XnatPvisitdata bill = new XnatPvisitdata(ItemSearch.GetItem("xnat:pvisitData/id", visit_id, null, true));
                        if(visits.get(bill) == null){
                    		visits.put(bill, new ArrayList<ExperimentAssessorContainer>());
                    	}
                    } catch (XFTInitException e) {
                        logger.error("",e);
                    } catch (ElementNotFoundException e) {
                        logger.error("",e);
                    }
                }
                
            } catch (Exception e) {
                logger.error("",e);
            }

		return visits;
	}
}
