package org.nrg.xnat.protocol;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;


public class ExpectedExperiment implements Comparable<ExpectedExperiment>{
   	private String createLink;
   	private String deleteLink;
   	private String editLink;
   	private String protocol;
   	private boolean required;
   	private Number sortOrder;
   	private String type;
   	private boolean userEntered;

 	public String getCreateLink(){
		return this.createLink;
	}
	public void setCreateLink(String createLink){
		this.createLink = createLink;
	}
 	public String getDeleteLink(){
		return this.deleteLink;
	}
	public void setDeleteLink(String deleteLink){
		this.deleteLink = deleteLink;
	}
 	public String getEditLink(){
		return this.editLink;
	}
	public void setEditLink(String editLink){
		this.editLink = editLink;
	}
 	public String getProtocol(){
		return this.protocol;
	}
	public void setProtocol(String protocol){
		this.protocol = protocol;
	}
 	public boolean getRequired(){
		return this.required;
	}
	public void setRequired(boolean required){
		this.required = required;
	}
 	public Number getSortOrder(){
		return this.sortOrder;
	}
	public void setSortOrder(Number sortOrder){
		this.sortOrder = sortOrder;
	}
 	public String getType(){
		return this.type;
	}
	public void setType(String type){
		this.type = type;
	}
 	public boolean getUserEntered(){
		return this.userEntered;
	}
	public void setUserEntered(boolean userEntered){
		this.userEntered = userEntered;
	}
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append(createLink).append("\n");
		sb.append(deleteLink).append("\n");
		sb.append(editLink).append("\n");
		sb.append(protocol).append("\n");
		sb.append(required).append("\n");
		sb.append(sortOrder).append("\n");
		sb.append(type).append("\n");
		sb.append(userEntered).append("\n");
		return sb.toString();
	}
	
	public int hashCode() {
        return new HashCodeBuilder(11, 37). // two randomly chosen prime numbers
            // if deriving: appendSuper(super.hashCode()).
        	append(this.getType()).
        	append(this.getProtocol()).
        	append(this.getRequired()).
        	append(this.getUserEntered()).
            toHashCode();
    }

	public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj == this)
            return true;
        if (obj.getClass() != getClass())
            return false;

        ExpectedExperiment rhs = (ExpectedExperiment) obj;
        return new EqualsBuilder().
            // if deriving: appendSuper(super.equals(obj)).
        	append(this.getType(), rhs.getType()).
        	append(this.getProtocol(), rhs.getProtocol()).
            append(this.getRequired(), rhs.getRequired()).
            append(this.getUserEntered(), rhs.getUserEntered()).
            isEquals();
    }

	public int compareTo(ExpectedExperiment rhs) {
		return new CompareToBuilder().
				append(this.getSortOrder(), rhs.getSortOrder()).
	            toComparison();
	}

}
