

/**
 * @param _proj_select
 * @param _subj_select
 * @param _submit_button
 * @param _defaultProject
 * @param _defaultSubject
 */
function VisitNameTypeSelector(_proj_select, _subj_select, _submit_button, _defaultProject, _defaultSubject, _defaultVisit, _defaultVisitType) {
    this.projectSelect = _proj_select;
    this.subjSelect = _subj_select;
    this.submitButton = _submit_button;
    this.defaultProject = _defaultProject;
    this.defaultSubject = _defaultSubject;
    this.defaultVisit = _defaultVisit;
    this.defaultVisitType = _defaultVisitType;
    this.visitSpan = document.getElementById('visit_entry');
    this.visitSelect = document.getElementById('xnat:pVisitData/visit_name');
    this.visitTypeSpan = document.getElementById('visit_type_entry');
    this.visitTypeSelect = document.getElementById('xnat:pVisitData/visit_type');

    this.init = function () {

        //load from search xml from server
        this.initCallback = {
            success:this.completeInit,
            failure:this.initFailure,
            scope:this
        };
    
        var params = "";

        params += "&owner=true";
        params += "&member=true";

        //noinspection JSUnresolvedVariable
        YAHOO.util.Connect.asyncRequest('GET', serverRoot + '/data/projects?format=json&timestamp=' + (new Date()).getTime() + params, this.initCallback, null, this);        
    };

    this.initFailure = function (o) {
        this.displayError("ERROR " + o.status + ": Failed to load project list.");
    };

    this.completeInit = function (o) {
        try {
            this.projectResultSet = eval("(" + o.responseText + ")");
        } catch (e) {
            this.displayError("ERROR " + o.status + ": Failed to parse project list.");
        }
        try {
            this.renderProjects();
        } catch (e) {
            this.displayError("ERROR : Failed to render project list: " + e.toString());
        }

        document.getElementsByName("xnat:pVisitData/date.month")[0].onchange = function(){  window.ProjectSubjectManager.manageLaunchUploaderButton(); };
        document.getElementsByName("xnat:pVisitData/date.date")[0].onchange = function(){ window.ProjectSubjectManager.manageLaunchUploaderButton(); };
        document.getElementsByName("xnat:pVisitData/date.year")[0].onchange = function(){ window.ProjectSubjectManager.manageLaunchUploaderButton(); };
        document.getElementById("xnat:pVisitData/closed").onchange = function(){ window.ProjectSubjectManager.manageLaunchUploaderButton(); };
        
        
    };
    
    this.renderProjects = function () {
        //noinspection JSUnresolvedVariable
        if (this.projectResultSet.ResultSet.Result.length == 0) {

        } else {
            this.projectBox = document.getElementById(this.projectSelect);
            this.projectBox.options[0] = new Option("SELECT", "");

            //noinspection JSUnresolvedVariable
            for (var pC = 0; pC < this.projectResultSet.ResultSet.Result.length; pC++) {
                //noinspection JSUnresolvedVariable
                var defaultSelected = !!(this.projectResultSet.ResultSet.Result[pC].id == this.defaultProject);
                //noinspection JSUnresolvedVariable
                this.projectBox.options[pC + 1] = new Option(this.projectResultSet.ResultSet.Result[pC].secondary_id, this.projectResultSet.ResultSet.Result[pC].id, defaultSelected, defaultSelected);
                if (defaultSelected) {
                    this.projectBox.selectedIndex = (this.projectBox.options.length - 1);
                }
            }

            this.projectBox.disabled = false;

            this.projectBox.manager = this;

            this.projectBox.onchange = function () {
                if (this.selectedIndex > 0) {
                    this.manager.projectID = this.options[this.selectedIndex].value;
                    this.manager.loadVisits();
                    this.manager.loadSubjects();
                }
                this.manager.manageLaunchUploaderButton();
            };

            if (this.projectBox.selectedIndex > 0) {
                this.projectBox.onchange();
            }
        }

    };

    
    this.loadVisits = function () {
    	try {
    		var protoCallback = {
    			success:function (o) {
    				try {
    					o.argument.protocol = eval("(" + o.responseText + ")");
    					o.argument.protocol.visitNames.sort(function (a, b) {
                            if (a["delta"] < b["delta"]) {
                                return -1;
                            } else if (b["delta"] < a["delta"]) {
                                return 1;
                            } else {
                                return 0;
                            }
                        });
    					
    				} catch (e) {
    					o.argument.displayError("ERROR " + o.status + ": Failed to parse protocol.");
    				}
    				try {
    					o.argument.renderVisits();
    				} catch (e) {
    					o.argument.displayError("ERROR : Failed to render subject list.");
    				}
    			},
    			failure:function () {
    				alert("Failed to load protocol.");
    			},
    			argument:this
    		};

    		YAHOO.util.Connect.asyncRequest('GET', serverRoot + '/data/projects/' + this.projectID + '/protocols?format=json&timestamp=' + (new Date()).getTime(), protoCallback);
    	} catch (e) {
            alert('failed to load protocol');
        }
    };

    
    this.updateVisitTypes = function () {
        this.visitTypeSelect.options[0] = new Option("SELECT", "", true, true);
        this.visitTypeSelect.options[0].style.color = "black";
        var result = this.protocol.visitNames[this.visitSelect.selectedIndex-1]["validTypes"];
        for (var sC = 0; sC < result.length; sC++) {
            var label = result[sC];
            

            
            var defaultSelected = (label.toLowerCase().indexOf( this.defaultVisitType.toLowerCase() )!= -1);
            if(this.defaultVisitType == "") {
            	defaultSelected = false;
            }
            this.visitTypeSelect.options[sC + 1] = new Option(label, label, defaultSelected, defaultSelected);
            this.visitTypeSelect.options[sC + 1].style.color = "black";

            if (defaultSelected) {
                this.visitTypeSelect.selectedIndex = (this.visitTypeSelect.options.length - 1);
            }
            
            
        }
        //this.visitTypeSelect.selectedIndex = 0;
        this.visitTypeSelect.disabled = false;
        this.visitTypeSelect.submitButton = this.submitButton;
        this.visitTypeSelect.manager = this;
        this.visitTypeSelect.onchange = function () {
            this.manager.manageLaunchUploaderButton();
        };

    };
    this.renderVisits = function () {
        this.visitTypeSpan.style.display = '';
        this.visitSpan.style.display = '';

        this.visitSelect.options[0] = new Option("SELECT", "", true, true);
        this.visitSelect.options[0].style.color = "black";

        var result = this.protocol.visitNames;
        for (var sC = 0; sC < result.length; sC++) {
            var label = result[sC]["name"];

            var defaultSelected = (label.toLowerCase().indexOf( this.defaultVisit.toLowerCase() )!= -1);
            if(this.defaultVisit == "") {
            	defaultSelected = false;
            }
            this.visitSelect.options[sC + 1] = new Option(label, label, defaultSelected, defaultSelected);
            if (defaultSelected) {
                this.visitSelect.selectedIndex = (this.visitSelect.options.length - 1);
            }
                        
        }

        this.visitSelect.disabled = false;
        this.visitSelect.submitButton = this.submitButton;
        this.visitSelect.manager = this;
        this.visitSelect.onchange = function () {
            if (YAHOO.env.ua.gecko > 0) {
                this.style.color = this.options[this.selectedIndex].style.color;
            }
            this.manager.updateVisitTypes();
            this.manager.manageLaunchUploaderButton();
        };
        if (this.visitSelect.selectedIndex > 0) {
            this.visitSelect.onchange();
        }

    };
    this.loadSubjects = function () {
        try {
            var subjCallback = {
                success:function (o) {
                    try {
                        o.argument.subjectResultSet = eval("(" + o.responseText + ")");
                        //noinspection JSUnresolvedVariable
                        o.argument.subjectResultSet.ResultSet.Result.sort(function (a, b) {
                            if (a["label"] < b["label"]) {
                                return -1;
                            } else if (b["label"] < a["label"]) {
                                return 1;
                            } else {
                                return 0;
                            }
                        });

                    } catch (e) {
                        o.argument.displayError("ERROR " + o.status + ": Failed to parse subject list.");
                    }
                    try {
                        o.argument.renderSubjects();
                    } catch (e) {
                        o.argument.displayError("ERROR : Failed to render subject list.");
                    }
                },
                failure:function () {
                    alert("Failed to load subjects.")
                },
                argument:this
            };

            if (this.subjectBox != undefined) {
                this.subjectBox.disabled = true;

                while (this.subjectBox.length > 0) {
                    this.subjectBox.remove(0);
                }
            }

            //noinspection JSUnresolvedVariable
            YAHOO.util.Connect.asyncRequest('GET', serverRoot + '/data/projects/' + this.projectID + '/subjects?format=json&timestamp=' + (new Date()).getTime(), subjCallback);
        } catch (e) {
            alert('failed to load subjects');
        }
    };

    this.renderSubjects = function () {
        this.subjectBox = document.getElementById(this.subjSelect);
        this.subjectBox.options[0] = new Option("SELECT", "");
        this.subjectBox.options[0].style.color = "black";

        //noinspection JSUnresolvedVariable
        if (this.subjectResultSet.ResultSet.Result.length == 0) {
            this.showMessage('No subjects found', 'The selected project has no subjects recorded yet. You should create a subject with which to associate uploaded scan data.', true);
            return;
        }

        var matched = false;
        //noinspection JSUnresolvedVariable
        for (var sC = 0; sC < this.subjectResultSet.ResultSet.Result.length; sC++) {
            //noinspection JSUnresolvedVariable
            var result = this.subjectResultSet.ResultSet.Result[sC];
            var defaultSelected = !!(result.ID == this.defaultSubject || result["label"] == this.defaultSubject);
            if (defaultSelected) {
                matched = true;
            }
            var _label = result["label"];
            _label = (_label == undefined || _label == "") ? result.ID : _label;
            this.subjectBox.options[sC + 1] = new Option(_label, result.ID, defaultSelected, defaultSelected);
            this.subjectBox.options[sC + 1].style.color = "black";
            if (defaultSelected) {
                this.subjectBox.selectedIndex = (this.subjectBox.options.length - 1);
                this.subjectID = this.subjectBox.options[this.subjectBox.selectedIndex].value;
            }
        }

        this.subjectBox.disabled = false;

        if (!matched && (this.defaultSubject != "NULL" && this.defaultSubject != "null" && this.defaultSubject != "" && this.defaultSubject != null)) {
            this.subjectBox.options[sC + 1] = new Option(this.defaultSubject, this.defaultSubject, true, true);
            this.subjectBox.options[sC + 1].newValue = true;
            this.subjectBox.options[sC + 1].style.color = "red";
            this.subjectBox.selectedIndex = (this.subjectBox.options.length - 1);
            if (YAHOO.env.ua.gecko > 0) {
                this.subjectBox.style.color = "red";
            }
        }

        this.subjectBox.submitButton = this.submitButton;
        this.subjectBox.manager = this;
        this.subjectBox.onchange = function () {
            if (YAHOO.env.ua.gecko > 0) {
                this.style.color = this.options[this.selectedIndex].style.color;
            }
            if (this.selectedIndex > 0) {
                this.manager.subjectID = this.options[this.selectedIndex].value;
                this.manager.loadSubjectVisits();
            }
            document.getElementById("scan_date").value = '';
            this.manager.manageLaunchUploaderButton();
        }
    };

    this.loadSubjectVisits = function () {
    	//this will load all the subject's current visits when it is implemented
    }
    //this function was renamed with DISABLED because it is not currently in use. It shows how one might query xnat for a list of subject's visits to be used int he dropdown.
    this.loadVisitsDISABLED = function () {
        try {
            var visitCallback = {
                success:function (o) {
                    try {
                        o.argument.visitResultSet = eval("(" + o.responseText + ")");
                    } catch (e) {
                        o.argument.displayError("ERROR " + o.status + ": Failed to parse visit list.");
                    }
                    try {
                        o.argument.renderVisits();
                    } catch (e) {
                        o.argument.displayError("ERROR : Failed to render visit list.");
                    }
                },
                failure:function (o) {
                    alert("Failed to load visits: " + o);
                },
                argument:this
            };

            var visitList = document.getElementById('visit_name');
            if (visitList != undefined) {
                visitList.disabled = true;

                while (visitList.length > 0) {
                    visitList.remove(0);
                }
            }

            //noinspection JSUnresolvedVariable
            var visitUri = serverRoot + '/data/services/protocols/project/' + this.projectID + '/subject/' + this.subjectID + '/visits?format=json&timestamp=' + (new Date()).getTime();
            YAHOO.util.Connect.asyncRequest('GET', visitUri, visitCallback);
        } catch (e) {
            alert('Failed to load visits: ' + e.status);
        }
    };

    this.renderSubjectVisits = function () {
    	//this renders all the subject's current visits for this project. in fact, it should probably disable or remove entries in the visit_name box...
    }
    this.DISABLErenderVisits = function () {
        this.scanTypeSpan.style.display = '';
        this.visitSpan.style.display = '';

        this.visitSelect.options[0] = new Option("SELECT", "");
        this.visitSelect.options[0].style.color = "black";

        //noinspection JSUnresolvedVariable
        var result = this.visitResultSet.ResultSet.Result;
        for (var sC = 0; sC < result["available"].length; sC++) {
            var label = result["available"][sC];
            this.visitSelect.options[sC + 1] = new Option(label, label);
            this.visitSelect.options[sC + 1].style.color = "black";
        }
        this.visitSelect.selectedIndex = 0;

        // Copy the visit results into the global visits array as an associative array.
        visits = new Array();
        var visitData = result["visit_data"];
        if (!visitData || visitData.length == 0) {
            this.showMessage('No visits found', 'The selected subject has no visits recorded yet. You should create a visit entry.', true);
        } else {
            for (var i = 0; i < visitData.length; i++) {
                var visit = visitData[i];
                visits[visit['visit_name']] = visit;
            }
        }

        this.visitSelect.disabled = false;
        this.visitSelect.submitButton = this.submitButton;
        this.visitSelect.manager = this;
        this.visitSelect.onchange = function () {
            if (YAHOO.env.ua.gecko > 0) {
                this.style.color = this.options[this.selectedIndex].style.color;
            }
            this.manager.manageLaunchUploaderButton();
        };
        this.scanTypeSelect.disabled = false;
        this.scanTypeSelect.submitButton = this.submitButton;
        this.scanTypeSelect.manager = this;
        this.scanTypeSelect.onchange = function () {
            if (YAHOO.env.ua.gecko > 0) {
                this.style.color = this.options[this.selectedIndex].style.color;
            }
            this.manager.manageLaunchUploaderButton();
        }
    };

    /**
     * This function takes an activate parameter. If the value of that parameter is null, the function will run through
     * a series of validity test of the criteria currently set in the input form. If the criteria is valid, the submit
     * button will be activated. Otherwise, if the value of the activate parameter is set to a boolean, the
     * button is activated if the value is true, and deactivated otherwise.
     * @param activate Indicates whether to activate the submit button. Set to null to force validity tests.
     */
    this.manageLaunchUploaderButton = function (activate) {
        var button = document.getElementById(this.submitButton);
        if (button) {
            if (activate == null) {
                activate = this.validateVisitCriteria();
            }
            button.disabled = !activate;
        }
    };

    this.validateVisitCriteria = function () {
    	//date is taken care of by XNAT.
    	var bSessionDate = !!(document.getElementsByName("xnat:pVisitData/date.month")[0].selectedIndex > 0 && document.getElementsByName("xnat:pVisitData/date.date")[0].selectedIndex > 0 && document.getElementsByName("xnat:pVisitData/date.year")[0].selectedIndex > 0);
    	var visitNameIdx = document.getElementById("xnat:pVisitData/visit_name").selectedIndex;
    	var visitTypeIdx = document.getElementById("xnat:pVisitData/visit_type").selectedIndex;
    	var projectIdx = document.getElementById("xnat:pVisitData/project").selectedIndex; //even though they're hidden half the time, the select boxes are still there.
    	var subjectIdx = document.getElementById("xnat:pVisitData/subject_id").selectedIndex; //even though they're hidden half the time, the select boxes are still there.
    	if( !bSessionDate ||  visitNameIdx == 0 || visitTypeIdx == 0 || projectIdx == 0 || subjectIdx == 0){
    		return false;
    	} else {
        	return true;    		
    	}
    		
    }

    this.showMessage = function (title, message, confirmOnly) {
        var buttonArray;
        if (!confirmOnly) {
             buttonArray = [{ text:'Yes', handler:handleYes, isDefault:true },
                 { text:'No', handler:handleNo }];
        } else {
            buttonArray = [{ text:'OK', handler:handleOK, isDefault:true }];
        }
        var dialog = new YAHOO.widget.SimpleDialog("dialog", {
            width:"20em",
            close:false,
            fixedcenter:true,
            constraintoviewport:true,
            modal:true,
            icon:YAHOO.widget.SimpleDialog.ICON_WARN,
            visible:true,
            draggable:false,
            buttons: buttonArray
        });

        dialog.manager = this;
        dialog.render(document.getElementById('layout_content'));
        dialog.setHeader(title);
        dialog.setBody(message);
        dialog.bringToTop();
        dialog.show();

        function handleYes() {
            this.hide();
            this.manager.manageLaunchUploaderButton(true);
        }

        function handleNo() {
            this.hide();
            this.manager.manageLaunchUploaderButton(false);
        }

        function handleOK() {
            this.hide();
        }
    }
}
